/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import io.airlift.bootstrap.ConcurrentWeakIdentitySet;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestConcurrentWeakIdentitySet {
    @Test
    public void testClearedReferences() {
        int iterations = 100000;
        ConcurrentWeakIdentitySet weakIdentitySet = new ConcurrentWeakIdentitySet();
        for (int i = 0; i < iterations; ++i) {
            weakIdentitySet.add((Object)new byte[1000000]);
        }
        System.gc();
        Assertions.assertThat((int)weakIdentitySet.size()).isLessThan(iterations);
    }

    @Test
    public void testIdentity() {
        ConcurrentWeakIdentitySet weakIdentitySet = new ConcurrentWeakIdentitySet();
        Assertions.assertThat((boolean)weakIdentitySet.add((Object)"test")).isTrue();
        Assertions.assertThat((boolean)weakIdentitySet.add((Object)"test")).isFalse();
        record Tester(String id) {
        }
        Tester one = new Tester("one");
        Assertions.assertThat((boolean)weakIdentitySet.add((Object)one)).isTrue();
        Assertions.assertThat((boolean)weakIdentitySet.add((Object)one)).isFalse();
        Assertions.assertThat((boolean)weakIdentitySet.add((Object)new Tester("one"))).isTrue();
    }
}

