/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TestBootstrapWithSecretsProvider {
    TestBootstrapWithSecretsProvider() {
    }

    @Test
    void testBootstrapWithDefaultSecretsProvider() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class)}).setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"foo.value", (Object)"${ENV:TEST_KEY}"));
        Injector injector = bootstrap.initialize();
        Assertions.assertThat((String)((FooConfig)injector.getInstance(FooConfig.class)).getValue()).isEqualTo("test_value");
    }

    @Test
    void testBootstrapWithEnvironmentSecretsProviderDisabled() throws Exception {
        Path configurationPluginDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        File configurationResolverFile = this.createConfigurationResolverFile("secrets-plugins-dir=\"%s\"".formatted(configurationPluginDirectory));
        System.setProperty("secretsConfig", configurationResolverFile.getAbsolutePath());
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class)}).loadSecretsPlugins().setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"foo.value", (Object)"${ENV:TEST_KEY}"));
        Assertions.assertThatThrownBy(() -> bootstrap.initialize()).hasMessageContaining("No secret provider for key 'env'");
    }

    @Test
    void testBootstrapWithEnvironmentSecretsProviderEnabled() throws Exception {
        Path configurationPluginDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        File configurationResolverFile = this.createConfigurationResolverFile("secrets-plugins-dir=\"%s\n\n[env]\nsecrets-provider.name=\"env\"\n".formatted(configurationPluginDirectory));
        System.setProperty("secretsConfig", configurationResolverFile.getAbsolutePath());
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class)}).loadSecretsPlugins().setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"foo.value", (Object)"${ENV:TEST_KEY}"));
        Injector injector = bootstrap.initialize();
        Assertions.assertThat((String)((FooConfig)injector.getInstance(FooConfig.class)).getValue()).isEqualTo("test_value");
    }

    @Test
    void testBootstrapWithEnvironmentSecretsProviderWithDifferentNamespace() throws Exception {
        Path configurationPluginDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        File configurationResolverFile = this.createConfigurationResolverFile("secrets-plugins-dir=\"%s\n\n[multi]\nsecrets-provider.name=\"env\"\n".formatted(configurationPluginDirectory));
        System.setProperty("secretsConfig", configurationResolverFile.getAbsolutePath());
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class)}).loadSecretsPlugins().setRequiredConfigurationProperties((Map)ImmutableMap.of((Object)"foo.value", (Object)"${MULTI:TEST_KEY}"));
        Injector injector = bootstrap.initialize();
        Assertions.assertThat((String)((FooConfig)injector.getInstance(FooConfig.class)).getValue()).isEqualTo("test_value");
    }

    private File createConfigurationResolverFile(String configurationFile) throws Exception {
        File tomlFile = File.createTempFile("config_resolver", ".toml");
        tomlFile.deleteOnExit();
        try (BufferedWriter writer = Files.newBufferedWriter(tomlFile.toPath(), new OpenOption[0]);){
            writer.append(configurationFile);
        }
        return tomlFile;
    }

    public static class FooConfig {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Config(value="foo.value")
        public FooConfig setValue(String value) {
            this.value = value;
            return this;
        }
    }
}

