/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.CreationException;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.ControllerWithInstance;
import io.airlift.bootstrap.InstanceWithLifecycle;
import io.airlift.bootstrap.InstanceWithLifecycleImpl;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigPropertyMetadata;
import io.airlift.configuration.ConfigSecuritySensitive;
import java.util.Collection;
import java.util.logging.Logger;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBootstrap {
    private static boolean fooInstanceCreated;

    @Test
    public void testRequiresExplicitBindings() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assertions.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            Assertions.assertThat((String)((Message)e.getErrorMessages().iterator().next()).getMessage()).contains(new CharSequence[]{"Explicit bindings are required"});
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assertions.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            Assertions.assertThat((String)((Message)e.getErrorMessages().iterator().next()).getMessage()).contains(new CharSequence[]{"circular dependencies are disabled"});
        }
    }

    @Test
    public void testUnusedProperty() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }}).setRequiredConfigurationProperty("foo.pasword", "foo").setRequiredConfigurationProperty("foo.disabled", "true");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> Assertions.assertThat((Collection)e.getErrors()).containsExactly((Object[])new Message[]{new Message("Configuration property 'foo.disabled' was not used. Did you mean to use 'foo.enabled'?"), new Message("Configuration property 'foo.pasword' was not used. Did you mean to use 'foo.password' or 'foo.password2'?")}));
    }

    @Test
    public void testUserErrorsReported() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            throw new RuntimeException("happy user error");
        }});
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> {
            Assertions.assertThat(e.getErrors().stream().map(Message::getMessage)).containsExactly((Object[])new String[]{"An exception was caught and reported. Message: happy user error"});
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("An exception was caught and reported. Message: happy user error");
        });
    }

    @Test
    public void testUserErrorsReportedWithConfigurationProblem() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            throw new RuntimeException("happy user error");
        }}).setRequiredConfigurationProperty("test-required", "foo");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> {
            Assertions.assertThat(e.getErrors().stream().map(Message::getMessage)).containsExactlyInAnyOrder((Object[])new String[]{"Configuration property 'test-required' was not used", "An exception was caught and reported. Message: happy user error"});
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("Configuration property 'test-required' was not used");
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("An exception was caught and reported. Message: happy user error");
        });
    }

    @Test
    public void testLoggingConfiguredOnce() {
        Logger root = Logger.getLogger("");
        new Bootstrap(new Module[0]).setOptionalConfigurationProperty("log.path", "tcp://0.0.0.0:0").initialize();
        int configuredHandlerCount = root.getHandlers().length;
        new Bootstrap(new Module[0]).setOptionalConfigurationProperty("log.path", "tcp://0.0.0.0:0").initialize();
        Assertions.assertThat((Object[])root.getHandlers()).hasSize(configuredHandlerCount);
    }

    @Test
    public void testSeparateConfigureAndInitialize() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).in(Scopes.SINGLETON);
        }});
        bootstrap.setOptionalConfigurationProperty("foo.enabled", "true");
        bootstrap.setOptionalConfigurationProperty("foo.password", "secret");
        bootstrap.setOptionalConfigurationProperty("bar.enabled", "true");
        fooInstanceCreated = false;
        Assertions.assertThat((Collection)bootstrap.configure()).containsExactly((Object[])new ConfigPropertyMetadata[]{new ConfigPropertyMetadata("foo.enabled", false), new ConfigPropertyMetadata("foo.password", true)});
        Assertions.assertThat((boolean)fooInstanceCreated).isFalse();
        bootstrap.initialize();
        Assertions.assertThat((boolean)fooInstanceCreated).isTrue();
    }

    @Test
    public void testConfigureWithConditionalModule() {
        AbstractConfigurationAwareModule module = new AbstractConfigurationAwareModule(this){

            protected void setup(Binder binder) {
                this.install(ConditionalModule.conditionalModule(FooConfig.class, FooConfig::isFoo, innerBinder -> ConfigBinder.configBinder((Binder)innerBinder).bindConfig(BarConfig.class)));
            }
        };
        Bootstrap bootstrap = new Bootstrap(new Module[]{module});
        bootstrap.setOptionalConfigurationProperty("foo.enabled", "true");
        bootstrap.setOptionalConfigurationProperty("foo.password", "secret");
        bootstrap.setOptionalConfigurationProperty("bar.enabled", "false");
        bootstrap.setOptionalConfigurationProperty("bar.password", "password");
        Assertions.assertThat((Collection)bootstrap.configure()).containsExactly((Object[])new ConfigPropertyMetadata[]{new ConfigPropertyMetadata("bar.enabled", false), new ConfigPropertyMetadata("bar.password", true), new ConfigPropertyMetadata("foo.enabled", false), new ConfigPropertyMetadata("foo.password", true)});
    }

    @Test
    public void testConfigureWithPropertyPrefix() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> ConfigBinder.configBinder((Binder)binder).bindConfig(BarConfig.class, "foo")});
        bootstrap.setOptionalConfigurationProperty("foo.bar.enabled", "true");
        bootstrap.setOptionalConfigurationProperty("foo.bar.password", "secret");
        bootstrap.setOptionalConfigurationProperty("bar.enabled", "true");
        bootstrap.setOptionalConfigurationProperty("bar.password", "secret");
        Assertions.assertThat((Collection)bootstrap.configure()).containsExactly((Object[])new ConfigPropertyMetadata[]{new ConfigPropertyMetadata("foo.bar.enabled", false), new ConfigPropertyMetadata("foo.bar.password", true)});
    }

    @Test
    public void testConfigureDoesNotInitializeEagerSingletons() {
        fooInstanceCreated = false;
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }});
        bootstrap.setOptionalConfigurationProperty("foo.enabled", "true");
        bootstrap.configure();
        Assertions.assertThat((boolean)fooInstanceCreated).isFalse();
    }

    @Test
    public void testSkipErrorReporting() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }});
        bootstrap.setOptionalConfigurationProperty("foo.enabled", "shouldBeBoolean");
        bootstrap.skipErrorReporting();
        bootstrap.configure();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOf(CreationException.class)).hasMessageContaining("Invalid value 'shouldBeBoolean' for type boolean (property 'foo.enabled')");
    }

    @Test
    public void testDisableEnvInterpolation() {
        FooConfig interpolatedConfig = (FooConfig)new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }}).setOptionalConfigurationProperty("foo.password", "${ENV:FOO_PASSWORD}").initialize().getInstance(FooConfig.class);
        Assertions.assertThat((String)interpolatedConfig.getPassword()).isEqualTo("superSecretPassword");
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }}).disableEnvInterpolation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap.setOptionalConfigurationProperty("foo.password", "${env:FOO_PASSWORD}")).initialize()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("No secret provider for key 'env'");
        Bootstrap otherBootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).asEagerSingleton();
        }}).disableEnvInterpolation();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((Bootstrap)otherBootstrap.setOptionalConfigurationProperty("foo.password", "${Env:FOO_PASSWORD}")).initialize()).isInstanceOf(ApplicationConfigurationException.class)).hasMessageContaining("No secret provider for key 'env'");
    }

    @Test
    public void testOptionalBindingWithLifeCycle() {
        Module module = binder -> {
            binder.bind(ControllerWithInstance.class).in(Scopes.SINGLETON);
            OptionalBinder.newOptionalBinder((Binder)binder, InstanceWithLifecycle.class).setDefault().to(InstanceWithLifecycleImpl.class).in(Scopes.SINGLETON);
        };
        Bootstrap bootstrap = new Bootstrap(new Module[]{module});
        LifeCycleManager lifeCycleManager = (LifeCycleManager)bootstrap.initialize().getInstance(LifeCycleManager.class);
        lifeCycleManager.stop();
    }

    public static class Instance {
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class FooConfig {
        private boolean foo;
        public String password;
        public String password2;

        public boolean isFoo() {
            return this.foo;
        }

        @Config(value="foo.enabled")
        public FooConfig setFoo(boolean foo) {
            this.foo = foo;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        @ConfigSecuritySensitive
        @Config(value="foo.password")
        public FooConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        public String getPassword2() {
            return this.password2;
        }

        @ConfigSecuritySensitive
        @Config(value="foo.password2")
        public FooConfig setPassword2(String password) {
            this.password2 = password;
            return this;
        }
    }

    public static class FooInstance {
        @Inject
        public FooInstance(FooConfig config) {
            fooInstanceCreated = true;
        }
    }

    public static class BarConfig {
        private boolean bar;
        public String password;

        public boolean isBar() {
            return this.bar;
        }

        @Config(value="bar.enabled")
        public BarConfig setBar(boolean bar) {
            this.bar = bar;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        @ConfigSecuritySensitive
        @Config(value="bar.password")
        public BarConfig setPassword(String password) {
            this.password = password;
            return this;
        }
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }
}

