/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Binder;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigBinder;
import java.util.Collection;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBootstrap {
    private static boolean fooInstanceCreated;

    @Test
    public void testRequiresExplicitBindings() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assertions.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assertions.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    @Test
    public void testUnusedProperty() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]).setRequiredConfigurationProperty("test-required", "foo");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> Assertions.assertThat((Collection)e.getErrors()).containsExactly((Object[])new Message[]{new Message("Configuration property 'test-required' was not used")}));
    }

    @Test
    public void testUserErrorsReported() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            throw new RuntimeException("happy user error");
        }});
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> {
            Assertions.assertThat(e.getErrors().stream().map(Message::getMessage)).containsExactly((Object[])new String[]{"An exception was caught and reported. Message: happy user error"});
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("An exception was caught and reported. Message: happy user error");
        });
    }

    @Test
    public void testUserErrorsReportedWithConfigurationProblem() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            throw new RuntimeException("happy user error");
        }}).setRequiredConfigurationProperty("test-required", "foo");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> {
            Assertions.assertThat(e.getErrors().stream().map(Message::getMessage)).containsExactlyInAnyOrder((Object[])new String[]{"Configuration property 'test-required' was not used", "An exception was caught and reported. Message: happy user error"});
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("Configuration property 'test-required' was not used");
            Assertions.assertThat((Throwable)e).hasStackTraceContaining("An exception was caught and reported. Message: happy user error");
        });
    }

    @Test
    public void testLoggingConfiguredOnce() {
        Logger root = Logger.getLogger("");
        new Bootstrap(new Module[0]).setOptionalConfigurationProperty("log.path", "tcp://0.0.0.0:0").initialize();
        int configuredHandlerCount = root.getHandlers().length;
        new Bootstrap(new Module[0]).setOptionalConfigurationProperty("log.path", "tcp://0.0.0.0:0").initialize();
        Assertions.assertThat((Object[])root.getHandlers()).hasSize(configuredHandlerCount);
    }

    @Test
    public void testSeparateConfigureAndInitialize() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            ConfigBinder.configBinder((Binder)binder).bindConfig(FooConfig.class);
            binder.bind(FooInstance.class).in(Scopes.SINGLETON);
        }});
        bootstrap.setOptionalConfigurationProperty("foo.enabled", "true");
        bootstrap.setOptionalConfigurationProperty("bar.enabled", "true");
        fooInstanceCreated = false;
        Assertions.assertThat((Collection)bootstrap.configure()).containsExactly((Object[])new String[]{"foo.enabled"});
        Assertions.assertThat((boolean)fooInstanceCreated).isFalse();
        bootstrap.initialize();
        Assertions.assertThat((boolean)fooInstanceCreated).isTrue();
    }

    public static class Instance {
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class FooConfig {
        private boolean foo;

        public boolean isFoo() {
            return this.foo;
        }

        @Config(value="foo.enabled")
        public FooConfig setFoo(boolean foo) {
            this.foo = foo;
            return this;
        }
    }

    public static class FooInstance {
        @Inject
        public FooInstance(FooConfig config) {
            fooInstanceCreated = true;
        }
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }
}

