/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.Inject;
import io.airlift.bootstrap.TestLifeCycleManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutedInstance
implements Runnable {
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch endLatch = new CountDownLatch(1);

    @Inject
    public ExecutedInstance() {
    }

    @PostConstruct
    public void startExecution() {
        this.executor.submit(this);
    }

    @PreDestroy
    public void stopExecution() {
        this.executor.shutdownNow();
    }

    public void waitForStart() throws InterruptedException {
        this.startLatch.await();
    }

    public void waitForEnd() throws InterruptedException {
        this.endLatch.await();
    }

    @Override
    public void run() {
        TestLifeCycleManager.note("Starting");
        this.startLatch.countDown();
        try {
            if (!Thread.interrupted()) {
                try {
                    Thread.sleep(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        finally {
            TestLifeCycleManager.note("Done");
            this.endLatch.countDown();
        }
    }
}

