/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.Bootstrap;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBootstrap {
    @Test
    public void testRequiresExplicitBindings() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]);
        try {
            bootstrap.initialize().getInstance(Instance.class);
            Assert.fail((String)"should require explicit bindings");
        }
        catch (ConfigurationException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"Explicit bindings are required");
        }
    }

    @Test
    public void testDoesNotAllowCircularDependencies() {
        Bootstrap bootstrap = new Bootstrap(new Module[]{binder -> {
            binder.bind(InstanceA.class);
            binder.bind(InstanceB.class);
        }});
        try {
            bootstrap.initialize().getInstance(InstanceA.class);
            Assert.fail((String)"should not allow circular dependencies");
        }
        catch (ProvisionException e) {
            io.airlift.testing.Assertions.assertContains((String)((Message)e.getErrorMessages().iterator().next()).getMessage(), (String)"circular dependencies are disabled");
        }
    }

    @Test
    public void testStrictConfig() {
        Bootstrap bootstrap = new Bootstrap(new Module[0]).setRequiredConfigurationProperty("test-required", "foo");
        Assertions.assertThatThrownBy(() -> ((Bootstrap)bootstrap).initialize()).isInstanceOfSatisfying(ApplicationConfigurationException.class, e -> Assertions.assertThat((Iterable)e.getErrors()).containsExactly((Object[])new Message[]{new Message("Configuration property 'test-required' was not used")}));
    }

    @Test
    public void testNonStrictConfig() {
        new Bootstrap(new Module[0]).setRequiredConfigurationProperty("test-required", "foo").nonStrictConfig().initialize();
    }

    public static class Instance {
    }

    public static class InstanceA {
        @Inject
        public InstanceA(InstanceB b) {
        }
    }

    public static class InstanceB {
        @Inject
        public InstanceB(InstanceA a) {
        }
    }
}

