/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.hadoop.compression.lzo.LzoCodec;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopNative;
import io.airlift.compress.MalformedInputException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;

public class HadoopLzoDecompressor
implements Decompressor {
    private static final Configuration HADOOP_CONF;
    private final org.apache.hadoop.io.compress.Decompressor decompressor;

    public HadoopLzoDecompressor() {
        LzoCodec codec = new LzoCodec();
        codec.setConf(HADOOP_CONF);
        this.decompressor = codec.createDecompressor();
    }

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        int offset;
        this.decompressor.reset();
        this.decompressor.setInput(input, inputOffset, inputLength);
        int outputLimit = outputOffset + maxOutputLength;
        for (offset = outputOffset; !this.decompressor.finished() && offset < outputLimit; offset += this.decompressor.decompress(output, offset, outputLimit - offset)) {
            try {
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return offset - outputOffset;
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static {
        HadoopNative.requireHadoopNative();
        HADOOP_CONF = new Configuration();
    }
}

