/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import io.airlift.compress.thirdparty.XerialSnappyCompressor;
import io.airlift.compress.thirdparty.XerialSnappyDecompressor;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestSnappy
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new SnappyCompressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new SnappyDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new XerialSnappyCompressor();
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new XerialSnappyDecompressor();
    }

    @Test
    public void testInvalidLiteralLength() {
        byte[] data = new byte[]{-128, 8, -4, -1, -1, -1, 127, 0, 0, 0, 0, 0, 0, 0, 0};
        Assertions.assertThatThrownBy(() -> new SnappyDecompressor().decompress(data, 0, data.length, new byte[1024], 0, 1024)).isInstanceOf(MalformedInputException.class);
    }

    @Test
    public void testNegativeLength() {
        byte[] data = new byte[]{-1, -1, -1, -1, 8};
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SnappyDecompressor.getUncompressedLength((byte[])data, (int)0)).isInstanceOf(MalformedInputException.class)).hasMessageStartingWith("negative compressed length");
    }
}

