/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.lzo;

import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopNative;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import io.airlift.compress.thirdparty.HadoopLzoCompressor;
import io.airlift.compress.thirdparty.HadoopLzoDecompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestLzo
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new LzoCompressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new LzoDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new HadoopLzoCompressor();
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new HadoopLzoDecompressor();
    }

    @Test
    public void testLiteralLengthOverflow() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(0);
        buffer.write(new byte[0x808081]);
        buffer.write(1);
        byte[] data = buffer.toByteArray();
        Assertions.assertThatThrownBy(() -> new LzoDecompressor().decompress(data, 0, data.length, new byte[20000], 0, 20000)).isInstanceOf(MalformedInputException.class);
    }

    @Test
    public void testMatchLengthOverflow1() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(0);
        buffer.write(new byte[66]);
        buffer.write(8);
        buffer.write(new byte[16856]);
        buffer.write(16);
        buffer.write(new byte[0x808081]);
        buffer.write(1);
        buffer.write(0);
        buffer.write(4);
        buffer.write(new byte[10]);
        byte[] data = buffer.toByteArray();
        Assertions.assertThatThrownBy(() -> new LzoDecompressor().decompress(data, 0, data.length, new byte[20000], 0, 20000)).isInstanceOf(MalformedInputException.class);
    }

    @Test
    public void testMatchLengthOverflow2() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(0);
        buffer.write(246);
        buffer.write(new byte[264]);
        buffer.write(32);
        buffer.write(new byte[0x808081]);
        buffer.write(1);
        buffer.write(0);
        buffer.write(4);
        buffer.write(new byte[10]);
        byte[] data = buffer.toByteArray();
        Assertions.assertThatThrownBy(() -> new LzoDecompressor().decompress(data, 0, data.length, new byte[20000], 0, 20000)).isInstanceOf(MalformedInputException.class);
    }

    static {
        HadoopNative.requireHadoopNative();
    }
}

