/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import com.google.common.io.Resources;
import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.benchmark.DataSet;
import io.airlift.compress.thirdparty.ZstdJniCompressor;
import io.airlift.compress.thirdparty.ZstdJniDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestZstd
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new ZstdCompressor();
    }

    @Override
    protected Decompressor getDecompressor() {
        return new ZstdDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new ZstdJniCompressor(3);
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new ZstdJniDecompressor();
    }

    @Test
    public void testDecompressWithOutputPaddingAndChecksum() throws IOException {
        int padding = 1021;
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum"));
        byte[] output = new byte[uncompressed.length + padding * 2];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressed.length, output, padding, output.length - padding);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, padding, decompressedSize);
    }

    @Test
    public void testConcatenatedFrames() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames"));
        byte[] output = new byte[uncompressed.length];
        this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, 0, output.length);
    }

    @Test
    public void testInvalidSequenceOffset() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/offset-before-start.zst"));
        byte[] output = new byte[compressed.length * 10];
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length)).isInstanceOf(MalformedInputException.class)).hasMessageStartingWith("Input is corrupted: offset=894");
    }

    @Test
    public void testSmallLiteralsAfterIncompressibleLiterals() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/small-literals-after-incompressible-literals"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testLargeRle() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/large-rle"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testIncompressibleData() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] original = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/incompressible"));
        int maxCompressLength = compressor.maxCompressedLength(original.length);
        byte[] compressed = new byte[maxCompressLength];
        int compressedSize = compressor.compress(original, 0, original.length, compressed, 0, compressed.length);
        byte[] decompressed = new byte[original.length];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressedSize, decompressed, 0, decompressed.length);
        TestZstd.assertByteArraysEqual(original, 0, original.length, decompressed, 0, decompressedSize);
    }

    @Test
    public void testMaxCompressedSize() {
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(0), (int)64);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(65536), (int)65824);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(131072), (int)131584);
        Assert.assertEquals((int)new ZstdCompressor().maxCompressedLength(131073), (int)131585);
    }

    @Test(dataProvider="data")
    public void testGetDecompressedSize(DataSet dataSet) {
        Compressor compressor = this.getCompressor();
        byte[] originalUncompressed = dataSet.getUncompressed();
        byte[] compressed = new byte[compressor.maxCompressedLength(originalUncompressed.length)];
        int compressedLength = compressor.compress(originalUncompressed, 0, originalUncompressed.length, compressed, 0, compressed.length);
        Assert.assertEquals((long)ZstdDecompressor.getDecompressedSize((byte[])compressed, (int)0, (int)compressedLength), (long)originalUncompressed.length);
        int padding = 10;
        byte[] compressedWithPadding = new byte[compressedLength + padding];
        Arrays.fill(compressedWithPadding, (byte)42);
        System.arraycopy(compressed, 0, compressedWithPadding, padding, compressedLength);
        Assert.assertEquals((long)ZstdDecompressor.getDecompressedSize((byte[])compressedWithPadding, (int)padding, (int)compressedLength), (long)originalUncompressed.length);
    }

    @Test
    public void testVerifyMagicInAllFrames() throws IOException {
        Compressor compressor = this.getCompressor();
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/bad-second-frame.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames"));
        byte[] output = new byte[uncompressed.length];
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length)).isInstanceOf(MalformedInputException.class)).hasMessageStartingWith("Invalid magic prefix");
    }

    @Test
    public void testDecompressIsMissingData() {
        byte[] input = new byte[]{40, -75, 47, -3, 32, 0, 1, 0};
        byte[] output = new byte[1024];
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getDecompressor().decompress(input, 0, input.length, output, 0, output.length)).matches(e -> e instanceof MalformedInputException || e instanceof UncheckedIOException)).hasMessageContaining("Not enough input bytes");
    }
}

