/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.zstd.Util;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestUtil {
    @DataProvider(name="test24bitIntegers")
    public static Object[][] test24bitIntegers() {
        return new Object[][]{{new byte[]{1, 0, 0, 0}, 0, 1}, {new byte[]{12, -83, 0, 0}, 0, 44300}, {new byte[]{0, 0, -128}, 0, 0x800000}, {new byte[]{-1, -1, -1}, 0, 0xFFFFFF}, {new byte[]{63, 25, 72, 0}, 0, 4725055}, {new byte[]{0, 0, 0, 0, 0, 0, 1, 0, 0}, 6, 1}};
    }

    @Test(dataProvider="test24bitIntegers")
    public void testGet24BitLittleEndian(byte[] bytes, int offset, int value) {
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        Assert.assertEquals((int)Util.get24BitLittleEndian((Object)bytes, (long)inputAddress), (int)value);
    }

    @Test(dataProvider="test24bitIntegers")
    public void testPut24BitLittleEndian(byte[] bytes, int offset, int value) {
        byte[] outputBase = new byte[bytes.length];
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        Util.put24BitLittleEndian((Object)outputBase, (long)outputAddress, (int)value);
        Assert.assertEquals((Object)outputBase, (Object)bytes);
    }
}

