/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.Compressor;
import io.airlift.compress.zstd.ZstdOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ZstdStreamCompressor
implements Compressor {
    public int maxCompressedLength(int uncompressedSize) {
        int result = uncompressedSize + (uncompressedSize >>> 8);
        if (uncompressedSize < 131072) {
            result += 131072 - uncompressedSize >>> 11;
        }
        return result;
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        ZstdStreamCompressor.verifyRange(input, inputOffset, inputLength);
        ZstdStreamCompressor.verifyRange(output, outputOffset, maxOutputLength);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(maxOutputLength);
        try (ZstdOutputStream zstdOutputStream = new ZstdOutputStream((OutputStream)byteArrayOutputStream);){
            zstdOutputStream.write(input, inputOffset, inputLength);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        byte[] compressed = byteArrayOutputStream.toByteArray();
        if (compressed.length > maxOutputLength) {
            throw new IllegalArgumentException("Output buffer too small");
        }
        System.arraycopy(compressed, 0, output, outputOffset, compressed.length);
        return compressed.length;
    }

    public void compress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

