/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.bzip2;

import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopCodecCompressor;
import io.airlift.compress.HadoopCodecDecompressor;
import io.airlift.compress.HadoopNative;
import io.airlift.compress.bzip2.BZip2Codec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;

public class TestBZip2Codec
extends AbstractTestCompression {
    private final CompressionCodec verifyCodec;

    public TestBZip2Codec() {
        org.apache.hadoop.io.compress.BZip2Codec codec = new org.apache.hadoop.io.compress.BZip2Codec();
        codec.setConf(new Configuration());
        this.verifyCodec = codec;
    }

    @Override
    protected boolean isByteBufferSupported() {
        return false;
    }

    @Override
    protected Compressor getCompressor() {
        return new HadoopCodecCompressor((CompressionCodec)new BZip2Codec(), TestBZip2Codec::guessMaxCompressedSize);
    }

    @Override
    protected Decompressor getDecompressor() {
        return new HadoopCodecDecompressor((CompressionCodec)new BZip2Codec());
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new HadoopCodecCompressor(this.verifyCodec, TestBZip2Codec::guessMaxCompressedSize);
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new HadoopCodecDecompressor(this.verifyCodec);
    }

    private static int guessMaxCompressedSize(int size) {
        return (int)((double)size * 1.2) + 256;
    }

    static {
        HadoopNative.requireHadoopNative();
    }
}

