/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import io.airlift.compress.zstd.ZstdIncrementalFrameDecompressor;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.testng.Assert;
import sun.misc.Unsafe;

public class ZstdPartialDecompressor
implements Decompressor {
    private final ZstdIncrementalFrameDecompressor decompressor = new ZstdIncrementalFrameDecompressor();

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        ZstdPartialDecompressor.verifyRange(input, inputOffset, inputLength);
        ZstdPartialDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        Assert.assertEquals((int)this.decompressor.getInputRequired(), (int)0);
        Assert.assertEquals((int)this.decompressor.getRequestedOutputSize(), (int)0);
        Assert.assertEquals((int)this.decompressor.getInputConsumed(), (int)0);
        Assert.assertEquals((int)this.decompressor.getOutputBufferUsed(), (int)0);
        int inputLimit = inputOffset + inputLength;
        int outputPosition = outputOffset;
        int outputLimit = outputOffset + maxOutputLength;
        for (int inputPosition = inputOffset; inputPosition < inputLimit || this.decompressor.getRequestedOutputSize() > 0; inputPosition += this.decompressor.getInputConsumed()) {
            if (this.decompressor.getInputRequired() > inputLimit - inputPosition) {
                throw new MalformedInputException((long)inputPosition, "Not enough input bytes");
            }
            if (outputPosition + this.decompressor.getRequestedOutputSize() > outputLimit) {
                throw new IllegalArgumentException("Output buffer too small");
            }
            byte[] inputChunk = Arrays.copyOfRange(input, inputPosition, inputPosition + this.decompressor.getInputRequired());
            byte[] outputBuffer = new byte[]{};
            if (this.decompressor.getRequestedOutputSize() > 0) {
                outputBuffer = new byte[this.decompressor.getRequestedOutputSize() > 500 ? this.decompressor.getRequestedOutputSize() - 457 : this.decompressor.getRequestedOutputSize()];
            }
            this.decompressor.partialDecompress((Object)inputChunk, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET, (long)(inputChunk.length + Unsafe.ARRAY_BYTE_BASE_OFFSET), outputBuffer, 0, outputBuffer.length);
            int outputBufferUsed = this.decompressor.getOutputBufferUsed();
            if (outputBufferUsed > 0) {
                Assert.assertTrue((outputPosition + outputBufferUsed <= outputLimit ? 1 : 0) != 0);
                System.arraycopy(outputBuffer, 0, output, outputPosition, outputBufferUsed);
                outputPosition += outputBufferUsed;
            }
            Assert.assertTrue((this.decompressor.getInputConsumed() <= inputChunk.length ? 1 : 0) != 0);
        }
        return outputPosition - outputOffset;
    }

    public void decompress(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

