/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.airlift.compress.deflate;

import io.airlift.compress.Compressor;

import java.nio.ByteBuffer;

public class MockJdkDeflateCompressor
        implements Compressor
{
    private static final int OVERHEAD = 128;

    public int maxCompressedLength(int uncompressedSize)
    {
        return uncompressedSize + OVERHEAD;
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength)
    {
        throw new UnsupportedOperationException("method is not supported");
    }

    @Override
    public void compress(ByteBuffer input, ByteBuffer output)
    {
        throw new UnsupportedOperationException("method is not supported");
    }
}
