/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Compressor;
import java.nio.ByteBuffer;

public class ZstdJniCompressor
implements Compressor {
    private final int level;

    public ZstdJniCompressor(int level) {
        this.level = level;
    }

    public int maxCompressedLength(int uncompressedSize) {
        return (int)Zstd.compressBound((long)uncompressedSize);
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        return (int)Zstd.compressByteArray((byte[])output, (int)outputOffset, (int)maxOutputLength, (byte[])input, (int)inputOffset, (int)inputLength, (int)this.level);
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        Zstd.compress((ByteBuffer)input, (ByteBuffer)output, (int)this.level);
    }
}

