/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress;

import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;

public class HadoopCodecDecompressor
implements Decompressor {
    private final CompressionCodec codec;

    public HadoopCodecDecompressor(CompressionCodec codec) {
        this.codec = codec;
    }

    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        int n;
        block10: {
            CompressionInputStream in = this.codec.createInputStream((InputStream)new ByteArrayInputStream(input, inputOffset, inputLength));
            try {
                int bytesRead;
                int size;
                for (bytesRead = 0; bytesRead < maxOutputLength && (size = in.read(output, outputOffset + bytesRead, maxOutputLength - bytesRead)) >= 0; bytesRead += size) {
                }
                if (in.read() >= 0) {
                    throw new RuntimeException("All input was not consumed");
                }
                n = bytesRead;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return n;
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

