/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.benchmark;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.HadoopCodecCompressor;
import io.airlift.compress.HadoopCodecDecompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.airlift.compress.lzo.LzoCodec;
import io.airlift.compress.lzo.LzoCompressor;
import io.airlift.compress.lzo.LzoDecompressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.snappy.SnappyDecompressor;
import io.airlift.compress.thirdparty.HadoopLzoCompressor;
import io.airlift.compress.thirdparty.HadoopLzoDecompressor;
import io.airlift.compress.thirdparty.Iq80SnappyCompressor;
import io.airlift.compress.thirdparty.Iq80SnappyDecompressor;
import io.airlift.compress.thirdparty.JPountzLz4Compressor;
import io.airlift.compress.thirdparty.JPountzLz4Decompressor;
import io.airlift.compress.thirdparty.JdkDeflateCompressor;
import io.airlift.compress.thirdparty.JdkInflateDecompressor;
import io.airlift.compress.thirdparty.XerialSnappyCompressor;
import io.airlift.compress.thirdparty.XerialSnappyDecompressor;
import io.airlift.compress.thirdparty.ZstdJniCompressor;
import io.airlift.compress.thirdparty.ZstdJniDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.Lz4Codec;
import org.apache.hadoop.io.compress.SnappyCodec;

public enum Algorithm {
    airlift_lz4((Decompressor)new Lz4Decompressor(), (Compressor)new Lz4Compressor()),
    airlift_snappy((Decompressor)new SnappyDecompressor(), (Compressor)new SnappyCompressor()),
    airlift_lzo((Decompressor)new LzoDecompressor(), (Compressor)new LzoCompressor()),
    airlift_zstd((Decompressor)new ZstdDecompressor(), (Compressor)new ZstdCompressor()),
    airlift_lz4_stream((CompressionCodec)new io.airlift.compress.lz4.Lz4Codec(), (Compressor)new Lz4Compressor()),
    airlift_snappy_stream((CompressionCodec)new io.airlift.compress.snappy.SnappyCodec(), (Compressor)new SnappyCompressor()),
    airlift_lzo_stream((CompressionCodec)new LzoCodec(), (Compressor)new LzoCompressor()),
    jpountz_lz4_jni(new JPountzLz4Decompressor(LZ4Factory.nativeInstance()), (Compressor)new JPountzLz4Compressor(LZ4Factory.nativeInstance())),
    jpountz_lz4_safe(new JPountzLz4Decompressor(LZ4Factory.safeInstance()), (Compressor)new JPountzLz4Compressor(LZ4Factory.safeInstance())),
    jpountz_lz4_unsafe(new JPountzLz4Decompressor(LZ4Factory.unsafeInstance()), (Compressor)new JPountzLz4Compressor(LZ4Factory.unsafeInstance())),
    xerial_snappy(new XerialSnappyDecompressor(), (Compressor)new XerialSnappyCompressor()),
    iq80_snappy(new Iq80SnappyDecompressor(), (Compressor)new Iq80SnappyCompressor()),
    hadoop_lzo(new HadoopLzoDecompressor(), (Compressor)new HadoopLzoCompressor()),
    zstd_jni(new ZstdJniDecompressor(), (Compressor)new ZstdJniCompressor(3)),
    hadoop_lz4_stream((CompressionCodec)new Lz4Codec(), (Compressor)new Lz4Compressor()),
    hadoop_snappy_stream((CompressionCodec)new SnappyCodec(), (Compressor)new SnappyCompressor()),
    hadoop_lzo_stream((CompressionCodec)new org.anarres.lzo.hadoop.codec.LzoCodec(), (Compressor)new LzoCompressor()),
    java_zip_stream(new JdkInflateDecompressor(), (Compressor)new JdkDeflateCompressor()),
    hadoop_gzip_stream((CompressionCodec)new GzipCodec(), (Compressor)new LzoCompressor());

    private final Decompressor decompressor;
    private final Compressor compressor;

    private Algorithm(CompressionCodec compressionCodec, Compressor compressor) {
        if (compressionCodec instanceof Configurable) {
            ((Configurable)compressionCodec).setConf(new Configuration());
        }
        this.decompressor = new HadoopCodecDecompressor(compressionCodec);
        this.compressor = new HadoopCodecCompressor(compressionCodec, compressor);
    }

    private Algorithm(Decompressor decompressor, Compressor compressor) {
        this.decompressor = decompressor;
        this.compressor = compressor;
    }

    public Compressor getCompressor() {
        return this.compressor;
    }

    public Decompressor getDecompressor() {
        return this.decompressor;
    }
}

