/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.zstd;

import com.google.common.io.Resources;
import io.airlift.compress.AbstractTestCompression;
import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.thirdparty.ZstdJniCompressor;
import io.airlift.compress.thirdparty.ZstdJniDecompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.net.URL;
import org.testng.annotations.Test;

public class TestZstd
extends AbstractTestCompression {
    @Override
    protected Compressor getCompressor() {
        return new ZstdJniCompressor(6);
    }

    @Override
    protected Decompressor getDecompressor() {
        return new ZstdDecompressor();
    }

    @Override
    protected Compressor getVerifyCompressor() {
        return new ZstdJniCompressor(6);
    }

    @Override
    protected Decompressor getVerifyDecompressor() {
        return new ZstdJniDecompressor();
    }

    @Test
    public void testDecompressWithOutputPaddingAndChecksum() throws IOException {
        int padding = 1021;
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/with-checksum"));
        byte[] output = new byte[uncompressed.length + padding * 2];
        int decompressedSize = this.getDecompressor().decompress(compressed, 0, compressed.length, output, padding, output.length);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, padding, decompressedSize);
    }

    @Test
    public void testConcatenatedFrames() throws IOException {
        byte[] compressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames.zst"));
        byte[] uncompressed = Resources.toByteArray((URL)this.getClass().getClassLoader().getResource("data/zstd/multiple-frames"));
        byte[] output = new byte[uncompressed.length];
        this.getDecompressor().decompress(compressed, 0, compressed.length, output, 0, output.length);
        TestZstd.assertByteArraysEqual(uncompressed, 0, uncompressed.length, output, 0, output.length);
    }
}

