/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Compressor;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdJniCompressor
implements Compressor {
    private final int level;

    public ZstdJniCompressor(int level) {
        this.level = level;
    }

    public int maxCompressedLength(int uncompressedSize) {
        return (int)Zstd.compressBound((long)uncompressedSize);
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        byte[] uncompressed = Arrays.copyOfRange(input, inputOffset, inputLength);
        byte[] compressed = Zstd.compress((byte[])uncompressed, (int)this.level);
        System.arraycopy(compressed, 0, output, outputOffset, compressed.length);
        return compressed.length;
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        byte[] uncompressed = new byte[input.remaining()];
        input.get(uncompressed);
        byte[] compressed = new byte[output.remaining()];
        int compressedSize = this.compress(uncompressed, 0, uncompressed.length, compressed, 0, compressed.length);
        output.put(compressed, 0, compressedSize);
    }
}

