/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.benchmark;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.Util;
import io.airlift.compress.benchmark.Algorithm;
import io.airlift.compress.benchmark.BytesCounter;
import io.airlift.compress.benchmark.DataSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.CommandLineOptionException;
import org.openjdk.jmh.runner.options.CommandLineOptions;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.util.Statistics;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Measurement(iterations=10)
@Warmup(iterations=5)
@Fork(value=3)
public class CompressionBenchmark {
    private Compressor compressor;
    private Decompressor decompressor;
    private byte[] uncompressed;
    private byte[] compressed;
    private byte[] compressTarget;
    private byte[] uncompressTarget;
    @Param(value={"airlift_lz4", "airlift_lzo", "airlift_snappy", "airlift_zstd", "iq80_snappy", "xerial_snappy", "jpountz_lz4_jni", "hadoop_lzo", "airlift_lz4_stream", "airlift_lzo_stream", "airlift_snappy_stream", "hadoop_lz4_stream", "hadoop_lzo_stream", "hadoop_snappy_stream", "java_zip_stream", "hadoop_gzip_stream"})
    private Algorithm algorithm;

    @Setup
    public void setup(DataSet data) throws IOException {
        this.uncompressed = data.getUncompressed();
        this.compressor = this.algorithm.getCompressor();
        this.compressTarget = new byte[this.compressor.maxCompressedLength(this.uncompressed.length)];
        this.decompressor = this.algorithm.getDecompressor();
        Compressor compressor = this.algorithm.getCompressor();
        this.compressed = new byte[compressor.maxCompressedLength(this.uncompressed.length)];
        int compressedLength = compressor.compress(this.uncompressed, 0, this.uncompressed.length, this.compressed, 0, this.compressed.length);
        this.compressed = Arrays.copyOf(this.compressed, compressedLength);
        this.uncompressTarget = new byte[this.uncompressed.length];
    }

    @Benchmark
    public int compress(BytesCounter counter) {
        int written = this.compressor.compress(this.uncompressed, 0, this.uncompressed.length, this.compressTarget, 0, this.compressTarget.length);
        counter.bytes += (long)this.uncompressed.length;
        return written;
    }

    @Benchmark
    public int decompress(BytesCounter counter) {
        int written = this.decompressor.decompress(this.compressed, 0, this.compressed.length, this.uncompressTarget, 0, this.uncompressTarget.length);
        counter.bytes += (long)this.uncompressed.length;
        return written;
    }

    public static void main(String[] args) throws RunnerException, CommandLineOptionException {
        CommandLineOptions parsedOptions = new CommandLineOptions(args);
        ChainedOptionsBuilder options = new OptionsBuilder().parent((Options)parsedOptions);
        if (parsedOptions.getIncludes().isEmpty()) {
            options = options.include(".*\\." + CompressionBenchmark.class.getSimpleName() + ".*");
        }
        Collection results = new Runner(options.build()).run();
        int count = 0;
        double sum = 0.0;
        for (RunResult result : results) {
            Statistics stats = ((Result)result.getSecondaryResults().get("bytes")).getStatistics();
            String algorithm = result.getParams().getParam("algorithm");
            String name = result.getParams().getParam("name");
            ++count;
            sum += 1.0 / stats.getMean();
            int compressSize = CompressionBenchmark.compressSize(algorithm, name);
            System.out.printf("  %-10s  %-22s  %-25s  %,11d  %10s \u00b1 %11s (%5.2f%%) (N = %d, \u03b1 = 99.9%%)\n", result.getPrimaryResult().getLabel(), algorithm, name, compressSize, Util.toHumanReadableSpeed((long)stats.getMean()), Util.toHumanReadableSpeed((long)stats.getMeanErrorAt(0.999)), stats.getMeanErrorAt(0.999) * 100.0 / stats.getMean(), stats.getN());
        }
        System.out.println();
        System.out.println("Overall: " + Util.toHumanReadableSpeed((long)((double)count / sum)));
        System.out.println();
    }

    private static int compressSize(String algorithmName, String name) {
        try {
            Compressor compressor = Algorithm.valueOf(algorithmName).getCompressor();
            DataSet dataSet = new DataSet(name);
            dataSet.loadFile();
            byte[] uncompressed = dataSet.getUncompressed();
            byte[] compressed = new byte[compressor.maxCompressedLength(uncompressed.length)];
            return compressor.compress(uncompressed, 0, uncompressed.length, compressed, 0, compressed.length);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

