/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.github.luben.zstd.Zstd;
import io.airlift.compress.Decompressor;
import io.airlift.compress.MalformedInputException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ZstdJniDecompressor
implements Decompressor {
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        byte[] compressed = Arrays.copyOfRange(input, inputOffset, inputLength);
        byte[] uncompressed = Zstd.decompress((byte[])compressed, (int)maxOutputLength);
        System.arraycopy(uncompressed, 0, output, outputOffset, uncompressed.length);
        return uncompressed.length;
    }

    public void decompress(ByteBuffer input, ByteBuffer output) throws MalformedInputException {
        throw new UnsupportedOperationException("not yet implemented");
    }
}

