/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.thirdparty;

import com.hadoop.compression.lzo.LzoCodec;
import io.airlift.compress.Compressor;
import io.airlift.compress.HadoopNative;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;

public class HadoopLzoCompressor
implements Compressor {
    private static final Configuration HADOOP_CONF;
    private final org.apache.hadoop.io.compress.Compressor compressor;

    public HadoopLzoCompressor() {
        LzoCodec codec = new LzoCodec();
        codec.setConf(HADOOP_CONF);
        this.compressor = codec.createCompressor();
    }

    public int maxCompressedLength(int uncompressedSize) {
        return uncompressedSize + uncompressedSize / 16 + 64 + 3;
    }

    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        int offset;
        this.compressor.reset();
        this.compressor.setInput(input, inputOffset, inputLength);
        this.compressor.finish();
        int outputLimit = outputOffset + maxOutputLength;
        for (offset = outputOffset; !this.compressor.finished() && offset < outputLimit; offset += this.compressor.compress(output, offset, outputLimit - offset)) {
            try {
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.compressor.finished()) {
            throw new RuntimeException("not enough space in output buffer");
        }
        return offset - outputOffset;
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    static {
        HadoopNative.requireHadoopNative();
        HADOOP_CONF = new Configuration();
    }
}

