/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.snappy;

import java.util.Random;

class RandomGenerator {
    public final byte[] data;
    public int position;

    public RandomGenerator(double compressionRatio) {
        Random rnd = new Random(301L);
        this.data = new byte[1048676];
        for (int i = 0; i < 0x100000; i += 100) {
            System.arraycopy(RandomGenerator.compressibleData(rnd, compressionRatio, 100), 0, this.data, i, 100);
        }
    }

    public int getNextPosition(int length) {
        if (this.position + length > this.data.length) {
            this.position = 0;
            assert (length < this.data.length);
        }
        int result = this.position;
        this.position += length;
        return result;
    }

    private static byte[] compressibleData(Random random, double compressionRatio, int length) {
        int chunkLength;
        int raw = (int)((double)length * compressionRatio);
        if (raw < 1) {
            raw = 1;
        }
        byte[] rawData = RandomGenerator.generateRandomData(random, raw);
        byte[] dest = new byte[length];
        for (int i = 0; i < length; i += chunkLength) {
            chunkLength = Math.min(rawData.length, length - i);
            System.arraycopy(rawData, 0, dest, i, chunkLength);
        }
        return dest;
    }

    private static byte[] generateRandomData(Random random, int length) {
        byte[] rawData = new byte[length];
        for (int i = 0; i < rawData.length; ++i) {
            rawData[i] = (byte)random.nextInt(256);
        }
        return rawData;
    }
}

