package io.aicactus.adsnetwork.utils

import android.net.Uri
import androidx.annotation.NonNull

class UriUtils {
    companion object {
        private fun uriBuilder(@NonNull baseUri: Uri, vararg newPathSegments: String): Uri.Builder {
            val builder = baseUri.buildUpon()
            for (path in newPathSegments) {
                builder.appendEncodedPath(path)
            }
            return builder
        }

        private fun uriBuilder(@NonNull baseUri: String, vararg newPathSegments: String): Uri.Builder {
            return uriBuilder(Uri.parse(baseUri), *newPathSegments)
        }

        private fun appendQueryParams(@NonNull uriBuilder: Uri.Builder, @NonNull queryParams: Map<String, String>): Uri.Builder {
            for (param in queryParams) {
                uriBuilder.appendQueryParameter(param.key, param.value)
            }
            return uriBuilder
        }

        fun appendQueryParams(@NonNull uri: Uri, @NonNull queryParams: Map<String, String>): Uri {
            return appendQueryParams(uriBuilder(uri), queryParams).build()
        }

        fun appendQueryParams(@NonNull baseUri: String, @NonNull queryParams: Map<String, String>): Uri {
            return appendQueryParams(Uri.parse(baseUri), queryParams)
        }

        fun buildUri(@NonNull baseUri: String, @NonNull vararg newPathSegments: String): Uri {
            return uriBuilder(baseUri, *newPathSegments).build()
        }

        fun buildUri(@NonNull baseUri: Uri, @NonNull vararg newPathSegments: String): Uri {
            return uriBuilder(baseUri, *newPathSegments).build()
        }
    }
}