package io.aicactus.adsnetwork.models.container

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

data class Inventory(@NonNull val id: Int) {

    @field:SerializedName("cpm")
    var cmp: Int? = null

    @field:SerializedName("ads_default")
    var defaultAds: Ad? = null

    @field:SerializedName("tracker_template")
    var trackerTemplate: TrackerTemplate? = null

    @field:SerializedName("dsps")
    var platforms: List<DemandSidePlatform>? = null

    @field:SerializedName("format")
    var format: String? = null

    @field:SerializedName("merge")
    var merge: String? = null

    @field:SerializedName("metadata")
    var metadata: Metadata? = null

    @field:SerializedName("name")
    var name: String? = null

    @field:SerializedName("status")
    var status: String? = null

    @field:SerializedName("type")
    var type: String? = null

    @field:SerializedName("floor_price")
    var floorPrice: Float = 0.0F

    @field:SerializedName("position_id")
    var positionId: Int? = null

    @field:SerializedName("click_rate")
    var clickRate: Int? = null

    @field:SerializedName("fill_rate")
    var fillRate: Int? = null

    data class TrackerTemplate(val id: String) {

        @field:SerializedName("click_image")
        var clickImage: String? = null

        @field:SerializedName("click_url")
        var clickUrl: String? = null

        @field:SerializedName("code")
        var code: String? = null

        @field:SerializedName("name")
        var name: String? = null

        @field:SerializedName("price")
        var price: Int? = null

        @field:SerializedName("type")
        var type: String? = null
    }

    class Metadata {
        @field:SerializedName("background")
        var background: String? = null

        @field:SerializedName("color")
        var color: String? = null

        @field:SerializedName("size")
        var size: String? = null
    }
}