package io.aicactus.adsnetwork.models.container

import com.google.gson.annotations.SerializedName

data class Container(
    @field:SerializedName("id")
    val id: Int,

    @field:SerializedName("core")
    val core: Core,

    @field:SerializedName("inventories")
    val inventories: List<Inventory>,

    @field:SerializedName("dsps")
    var platforms: List<DemandSidePlatform>?,

    @field:SerializedName("capping")
    var capping: Capping,
) {
    var configurationID: String? = null

    @field:SerializedName("name")
    var name: String? = null

    @field:SerializedName("publisher_id")
    var publisherId: String? = null

    @field:SerializedName("status")
    var status: String? = null

    @field:SerializedName("url")
    var url: String? = null

    data class Core(
        @field:SerializedName("url")
        var url: String,

        @field:SerializedName("type")
        var type: String,

        @field:SerializedName("name")
        var name: String,

        @field:SerializedName("domain")
        var domain: String,
    )
}