package io.aicactus.adsnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

class Video(
    /**
     * Content MIME types supported (e.g., “video/x-ms-wmv”, “video/mp4”).
     */
    @field:SerializedName("mimes")
    @NonNull val mines: Array<String>,
) {

    /**
     * Minimum video ad duration in seconds.
     */
    @field:SerializedName("minduration")
    var minDuration: Int? = null

    /**
     * Maximum video ad duration in seconds.
     */
    @field:SerializedName("maxduration")
    var maxDuration: Int? = null

    /**
     * Array of supported video [Protocol].
     * At least one supported protocol must be specified in either the protocol or protocols attribute.
     */
    @field:SerializedName("protocols")
    var protocols: Array<Int>? = null

    /**
     * Width of the video player in device independent pixels (DIPS).
     */
    @field:SerializedName("w")
    var width: Int? = null

    /**
     * Height of the video player in device independent pixels (DIPS).
     */
    @field:SerializedName("h")
    var height: Int? = null

    /**
     * Indicates the start delay in seconds for pre-roll, mid-roll, or post-roll ad placements.
     */
    @field:SerializedName("startdelay")
    var startDelay: Int? = null

    /**
     * [VideoPlacement] type for the impression.
     */
    @field:SerializedName("placement")
    var placement: Int? = null

    /**
     * Indicates if the impression must be linear, nonlinear, etc.
     * If none specified, assume all are allowed.
     */
    @field:SerializedName("linearity")
    var linearity: Int? = null

    /**
     * Indicates if the player will allow the video to be skipped, where 0 = no, 1 = yes.
     * If a bidder sends markup/creative that is itself skip-able,
     * the Bid object should include the attr array with an element of 16 indicating skip-able video.
     */
    @field:SerializedName("skip")
    var skip: Int? = null

    /**
     * Videos of total duration greater than this number of seconds can be skip-able;
     * only applicable if the ad is skip-able.
     */
    @field:SerializedName("skipmin")
    var skipMin: Int? = null

    /**
     * Number of seconds a video must play before skipping is enabled;
     * only applicable if the ad is skip-able.
     */
    @field:SerializedName("skipafter")
    var skipAfter: Int? = null

    /**
     * If multiple ad impressions are offered in the same bid request,
     * the sequence number will allow for the coordinated delivery of multiple creatives.
     */
    @field:SerializedName("sequence")
    var sequence: Int? = null

    /**
     * Blocked creative attributes.
     */
    @field:SerializedName("battr")
    var attributes: Array<CreativeAttribute>? = null

    /**
     * Maximum extended ad duration if extension is allowed.
     * If blank or 0, extension is not allowed.
     * If -1, extension is allowed, and there is no time limit imposed.
     * If greater than 0, then the value represents the number of seconds of extended play
     * supported beyond the [maxDuration] value.
     */
    @field:SerializedName("maxextended")
    var maxExtended: Int? = null

    /**
     * Minimum bit rate in Kbps.
     */
    @field:SerializedName("minbitrate")
    var minBitrate: Int? = null

    /**
     * Maximum bit rate in Kbps.
     */
    @field:SerializedName("maxbitrate")
    var maxBitrate: Int? = null

    /**
     * Indicates if letter-boxing of 4:3 content into a 16:9 window is allowed, where 0 = no, 1 = yes.
     */
    @field:SerializedName("boxingallowed")
    var boxingAllowed: Int? = null

    /**
     * [PlaybackMethod] that may be in use.
     * If none are specified, any method may be used.
     * Only one method is typically used in practice.
     * As a result, this array may be converted to an integer in a future version of the specification.
     * It is strongly advised to use only the first element of this array in preparation for this change.
     */
    @field:SerializedName("playbackmethod")
    var playbackMethod: Array<Int>? = null

    /**
     * The event that causes playback to end.
     */
    @field:SerializedName("playbackend")
    var playbackEnd: Int? = null

    /**
     * Supported delivery methods (e.g., streaming, progressive).
     * If none specified, assume all are supported.
     */
    @field:SerializedName("delivery")
    var deliveryMethod: Array<DeliveryMethod>? = null

    /**
     * Ad position on screen.
     */
    @field:SerializedName("pos")
    var position: AdPosition? = null

    /**
     * Array of [Banner] objects if companion ads are available.
     */
    @field:SerializedName("companionad")
    var companionAds: Array<Banner>? = null

    /**
     * List of supported [ApiFramework] for this impression.
     * If an API is not explicitly listed, it is assumed not to be supported.
     */
    @field:SerializedName("api")
    var apis: Array<ApiFramework>? = null

    /**
     * Supported VAST companion ad types.
     * Recommended if companion [Banner] objects are included via the [companionAds].
     * If one of these banners will be rendered as an end-card,
     * this can be specified using the [Banner.videoCompanion] attribute with the particular banner.
     */
    @field:SerializedName("companiontype")
    var companionTypes: Array<CompanionType>? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}