package io.aicactus.adsnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * This object contains information known or derived about the human user of the device
 * (i.e., the audience for advertising). The user id is an exchange artifact
 * and may be subject to rotation or other privacy policies.
 * However, this user ID must be stable long enough to serve reasonably as the basis for frequency capping and retargeting.
 */
class User {
    /**
     * Exchange-specific ID for the user.
     * At least one of id or [buyerUID] is recommended.
     */
    @field:SerializedName("id")
    var id: String? = null

    /**
     * Buyer-specific ID for the user as mapped by the exchange for the buyer.
     * At least one of [buyerUID] or [id] is recommended.
     */
    @field:SerializedName("buyeruid")
    var buyerUID: String? = null

    /**
     * Year of birth as a 4-digit integer.
     */
    @field:SerializedName("yob")
    var yearOfBirth: Int? = null

    /**
     * Gender, where “M” = male, “F” = female, “O” = known to be other (i.e., omitted is unknown).
     */
    @field:SerializedName("gender")
    var gender: Char = Gender.OTHER.value

    /**
     * Comma separated list of keywords, interests, or intent.
     */
    @field:SerializedName("keywords")
    var keywords: String? = null

    /**
     * Optional feature to pass bidder data that was set in the exchange’s cookie.
     * The string must be in base85 cookie safe characters and be in any format.
     * Proper JSON encoding must be used to include “escaped” quotation marks.
     */
    @field:SerializedName("customdata")
    var customData: String? = null

    /**
     * Location of the user’s home base defined by a Geo object.
     * This is not necessarily their current location.
     */
    @field:SerializedName("geo")
    var geo: Geo? = null

    /**
     * Additional user data. Each [Data] object represents a different data source.
     */
    @field:SerializedName("data")
    var data: Data? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null

    enum class Gender(val value: Char) {
        MALE('M'),
        FEMALE('F'),
        OTHER('O'),
    }
}