package io.aicactus.adsnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * Segment objects are essentially key-value pairs that convey specific units of data.
 * The parent [Data] object is a collection of such values from a given data provider.
 * The specific segment names and value options must be published by the exchange a priori to its bidders.
 */
class Segment {
    /**
     * ID of the data segment specific to the data provider.
     */
    @field:SerializedName("id")
    var id: String? = null

    /**
     * Name of the data segment specific to the data provider.
     */
    @field:SerializedName("name")
    var name: String? = null

    /**
     * String representation of the data segment value.
     */
    @field:SerializedName("value")
    var value: String? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}