package io.aicactus.adsnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

/**
 * A bid response can contain multiple SeatBid objects,
 * each on behalf of a different bidder seat and each containing one or more individual bids.
 * If multiple impressions are presented in the request,
 * the group attribute can be used to specify
 * if a seat is willing to accept any impressions that it can win (default)
 * or if it is only interested in winning any if it can win them all as a group.
 */
class SeatBid(
    /**
     * Array of 1+ [Bid] objects each related to an impression.
     * Multiple bids can relate to the same impression.
     */
    @field:SerializedName("bid")
    @NonNull val bids: List<Bid>,
) {

    /**
     * ID of the buyer seat (e.g., advertiser, agency) on whose behalf this bid is made.
     */
    @field:SerializedName("seat")
    var seat: String? = null

    /**
     *  0 = impressions can be won individually;
     *  1 = impressions must be won or lost as a group.
    */
    @field:SerializedName("group")
    var group: Int = 0

    /**
     * Placeholder for bidder-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}