package io.aicactus.adsnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

/**
 * Native ad units are intended to blend seamlessly into the surrounding content (e.g., a sponsored Twitter or Facebook post).
 * As such, the response must be well-structured to afford the publisher fine-grained control over rendering.
 */
class Native(
    /**
     * Request payload complying with the Native Ad Specification.
     */
    @field:SerializedName("request")
    @NonNull val request: String,
) {

    /**
     * Version of the Dynamic Native Ads API to which [request] complies;
     * highly recommended for efficient parsing.
     */
    @field:SerializedName("ver")
    var version: String = "1.2"

    /**
     * List of supported [ApiFramework] for this impression.
     * If an API is not explicitly listed, it is assumed not to be supported.
     */
    @field:SerializedName("api")
    var apis: Array<ApiFramework>? = null

    /**
     * Blocked creative attributes.
     */
    @field:SerializedName("battr")
    var attributes: Array<CreativeAttribute>? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}