package io.aicactus.adsnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

/**
 * This object describes an ad placement or impression being auctioned.
 * A single bid request can include multiple Imp objects,
 * a use case for which might be an exchange that supports selling all ad positions on a given page.
 * Each Imp object has a required ID so that bids can reference them individually.
 */
class Impression(
    /**
     * A unique identifier for this impression within the context of the bid request
     */
    @field:SerializedName("id")
    @NonNull val id: String) {

    /**
     * An array of Metric object.
     */
    @field:SerializedName("metric")
    var metric: Array<Metric>? = null

    /**
     * A [Banner] object required if this impression is offered as a banner ad opportunity.
     */
    @field:SerializedName("banner")
    var banner: Banner? = null

    /**
     * A [Video] object required if this impression is offered as a video ad opportunity.
     */
    @field:SerializedName("video")
    var video: Video? = null

    /**
     * An [Audio] object required if this impression is offered as an audio ad opportunity.
     */
    @field:SerializedName("audio")
    var audio: Audio? = null

    /**
     * A [Native] object required if this impression is offered as a native ad opportunity.
     */
    @field:SerializedName("native")
    var native: Native? = null

    /**
     * A Pmp object containing any private marketplace deals in effect for this impression.
     */
    @field:SerializedName("pmp")
    var pmp: Pmp? = null

    /**
     * Name of ad mediation partner, SDK technology,
     * or player responsible for rendering ad (typically video or mobile).
     * Used by some ad servers to customize ad code by partner.
     * Recommended for video and/or apps.
     */
    @field:SerializedName("displaymanager")
    var displayManager: String? = null

    /**
     * Version of ad mediation partner, SDK technology,
     * or player responsible for rendering ad (typically video or mobile).
     * Used by some ad servers to customize ad code by partner.
     * Recommended for video and/or apps.
     */
    @field:SerializedName("displaymanagerver")
    var displayManagerVersion: String? = null

    /**
     * 1 = the ad is interstitial or full screen, 0 = not interstitial.
     */
    @field:SerializedName("instl")
    var interstitial: Int? = null

    /**
     * Identifier for specific ad placement or ad tag that was used to initiate the auction.
     * This can be useful for debugging of any issues, or for optimization by the buyer.
     */
    @field:SerializedName("tagid")
    var tagId: String? = null

    /**
     * Minimum bid for this impression expressed in CPM.
     */
    @field:SerializedName("bidfloor")
    var bidFloor: Int? = null

    /**
     * Currency specified using ISO-4217 alpha codes.
     * This may be different from bid currency returned by bidder if this is allowed by the exchange.
     */
    @field:SerializedName("bidfloorcur")
    var bidFloorCurrency: String? = null

    /**
     * Indicates the type of browser opened upon clicking the creative in an app,
     * where 0 = embedded, 1 = native.
     */
    @field:SerializedName("clickbrowser")
    var clickBrowser: Int? = null

    /**
     * Flag to indicate if the impression requires secure HTTPS URL creative assets and markup,
     * where 0 = non-secure, 1 = secure.
     * If omitted, the secure state is unknown, but non-secure HTTP support can be assumed.
     */
    @field:SerializedName("secure")
    var secure: Int = 1

    /**
     * Array of exchange-specific names of supported iframe busters.
     */
    @field:SerializedName("iframebuster")
    var iframeBuster: Array<String>? = null

    /**
     * Advisory as to the number of seconds that may elapse between the auction and the actual impression.
     */
    @field:SerializedName("exp")
    var expire: Int? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Extension? = null

    class Extension {
        @field:SerializedName("prebid")
        var preBid: PreBid? = null

        @field:SerializedName("aicadn")
        var aicactusAds: AiCactusAd? = null

        class AiCactusAd {
            @field:SerializedName("header_bids")
            var headerBids: List<String>? = null

            @field:SerializedName("container_id")
            var containerId: Int? = null

            @field:SerializedName("inventory_id")
            var inventoryId: Int? = null
        }
    }
}
