package io.aicactus.adsnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The data and segment objects together allow additional data about
 * the related object (e.g., user, content) to be specified.
 * This data may be from multiple sources whether from the exchange itself or
 * third parties as specified by the id field.
 * A bid request can mix data objects from multiple providers.
 * The specific data providers in use should be published by the exchange a priori to its bidders.
 */
class Data {
    /**
     * Exchange-specific ID for the data provider.
     */
    @field:SerializedName("id")
    var id: String? = null

    /**
     * Exchange-specific name for the data provider.
     */
    @field:SerializedName("name")
    var name: String? = null

    /**
     * Array of [Segment] objects that contain the actual data values.
     */
    @field:SerializedName("segment")
    var segment: Array<Segment>? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}