package io.aicactus.adsnetwork.models.bid

/**
 * Describe an ad being served or serve as restrictions of thereof.
 */
enum class CreativeAttribute(val value: Int) {

    /**
     * Audio Ad (Auto-Play)
     */
    AUDIO_AD_AUTO_PLAY(1),

    /**
     * Audio Ad (User Initiated)
     */
    AUDIO_AD_USER_INITIATED(2),

    /**
     * Expandable (Automatic)
     */
    EXPANDABLE_AUTOMATIC(3),

    /**
     * Expandable (User Initiated - Click)
     */
    EXPANDABLE_USER_CLICKED(4),

    /**
     * Expandable (User Initiated - Rollover)
     */
    EXPANDABLE_USER_ROLLOVER(5),

    /**
     * In-Banner Video Ad (Auto-Play)
     */
    VIDEO_AD_IN_BANNER_AUTO_PLAY(6),

    /**
     * In-Banner Video Ad (User Initiated)
     */
    VIDEO_AD_IN_BANNER_USER_INITIATED(7),

    /**
     * Pop (e.g., Over, Under, or Upon Exit)
     */
    POP(8),

    /**
     * Provocative or Suggestive Imagery
     */
    PROVOCATIVE_OR_SUGGESTIVE_IMAGERY(9),

    /**
     * Shaky, Flashing, Flickering, Extreme Animation, Smileys
     */
    ANIMATION(10),

    /**
     * Surveys
     */
    SURVEYS(11),

    /**
     * Text Only
     */
    TEXT_ONLY(12),

    /**
     * User Interactive (e.g., Embedded Games)
     */
    USER_INTERACTIVE(13),

    /**
     * Windows Dialog or Alert Style
     */
    ALERT_STYLE(14),

    /**
     * Has Audio On/Off Button
     */
    HAS_AUDIO_ON_OFF_BUTTON(15),

    /**
     * Ad Provides Skip Button (e.g. VPAID-rendered skip button on pre-roll video)
     */
    PROVIDE_SKIP_BUTTON(16),

    /**
     * Adobe Flash
     */
    ADOBE_FLASH(17)
}