package io.aicactus.adsnetwork.models.bid

import androidx.annotation.NonNull
import com.google.gson.annotations.SerializedName

class Audio(
    /**
     * Content MIME types supported (e.g., “audio/mp4”).
     */
    @field:SerializedName("mines")
    @NonNull val mines: Array<String>,
) {

    /**
     * Minimum audio ad duration in seconds.
     */
    @field:SerializedName("minduration")
    var minDuration: Int? = null

    /**
     * Maximum audio ad duration in seconds.
     */
    @field:SerializedName("maxduration")
    var maxDuration: Int? = null

    /**
     * Array of supported audio protocols.
     */
    @field:SerializedName("protocols")
    var protocols: Array<Protocol>? = null

    /**
     * Indicates the start delay in seconds for pre-roll, mid-roll, or post-roll ad placements.
     */
    @field:SerializedName("startdelay")
    var startDelay: Int? = null

    /**
     * If multiple ad impressions are offered in the same bid request,
     * the sequence number will allow for the coordinated delivery of multiple creatives.
     */
    @field:SerializedName("sequence")
    var sequence: Int? = null

    /**
     * Blocked creative attributes.
     */
    @field:SerializedName("battr")
    var attributes: Array<CreativeAttribute>? = null

    /**
     * Maximum extended ad duration if extension is allowed.
     * If blank or 0, extension is not allowed.
     * If -1, extension is allowed, and there is no time limit imposed.
     * If greater than 0, then the value represents the number of seconds of extended play
     * supported beyond the [maxDuration] value.
     */
    @field:SerializedName("maxextended")
    var maxExtended: Int? = null

    /**
     * Minimum bit rate in Kbps.
     */
    @field:SerializedName("minbitrate")
    var minBitrate: Int? = null

    /**
     * Maximum bit rate in Kbps.
     */
    @field:SerializedName("maxbitrate")
    var maxBitrate: Int? = null

    /**
     * Supported delivery methods (e.g., streaming, progressive).
     * If none specified, assume all are supported.
     */
    @field:SerializedName("delivery")
    var deliveryMethod: Array<DeliveryMethod>? = null

    /**
     * Array of [Banner] objects if companion ads are available.
     */
    @field:SerializedName("companionad")
    var companionAds: Array<Banner>? = null

    /**
     * List of supported [ApiFramework] for this impression.
     * If an API is not explicitly listed, it is assumed not to be supported.
     */
    @field:SerializedName("api")
    var apis: Array<ApiFramework>? = null

    /**
     * Supported DAAST companion ad types.
     * Recommended if companion [Banner] objects are included via the [companionAds].
     */
    @field:SerializedName("companiontype")
    var companionTypes: Array<CompanionType>? = null

    /**
     * The maximum number of ads that can be played in an ad pod.
     */
    @field:SerializedName("maxseq")
    var maxSequence: Int? = null

    /**
     * Type of audio feed.
     */
    @field:SerializedName("feed")
    var feed: FeedType? = null

    /**
     * Indicates if the ad is stitched with audio content or delivered independently,
     * where 0 = no, 1 = yes.
     */
    @field:SerializedName("stitched")
    var stitched: Int? = null

    /**
     * Volume normalization mode.
     */
    @field:SerializedName("nvol")
    var volumeMode: VolumeMode? = null

    /**
     * Placeholder for exchange-specific extensions to OpenRTB.
     */
    @field:SerializedName("ext")
    var extension: Any? = null
}