package io.aicactus.adsnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The video object to be used for all video elements supported in the Native Ad.
 * This corresponds to the Video object of OpenRTB.
 * Exchange implementers can impose their own specific restrictions.
 * Here are the required attributes of the Video Object.
 * For optional attributes please refer to OpenRTB.
 */
sealed class AssetVideo {

    data class Request(
        /**
         * Content MIME types supported. Popular MIME types include,but are not limited to “video/x-ms-wmv”
         * for Windows Media, and “video/x-flv” for Flash Video, or “video/mp4”.
         * Note that native frequently does not support flash.
         */
        @SerializedName("mines")
        private val mines: List<String>,

        /**
         * Minimum video ad duration in seconds.
         */
        @SerializedName("minduration")
        private val minDuration: Int,

        /**
         * Maximum video ad duration in seconds.
         */
        @SerializedName("maxduration")
        private val maxDuration: Int,

        /**
         * An array of video protocols [Protocol] the publisher can accept in the bid response.
         */
        @SerializedName("protocols")
        private val protocols: List<Int>,

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null,
    )

    data class Response(
        /**
         * VAST XML
         */
        @SerializedName("vastxml")
        val vastTag: String,
    )
}