package io.aicactus.adsnetwork.models.bid

import com.google.gson.annotations.SerializedName

/**
 * The Title object is to be used for title element of the Native ad.
 */
class AssetTitle {

    class Request(
        /**
         * Maximum length of the text in the title element. Recommended to be 25, 90, or 140.
         */
        @SerializedName("len")
        val length: Int
    ) {
        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }

    class Response(
        /**
         * The text associated with the text element.
         */
        @SerializedName("text")
        val text: String
    ) {
        /**
         * The length of the title being provided. Required if using assetsurl/dcourl representation,
         * optional if using embedded asset representation.
         */
        @SerializedName("len")
        var length: Int? = null

        /**
         * Placeholder for exchange-specific extensions to OpenRTB.
         */
        @field:SerializedName("ext")
        var extension: Any? = null
    }
}