package io.aicactus.adsnetwork.models.batch

import android.annotation.SuppressLint
import android.content.Context
import android.content.pm.PackageManager
import android.os.Build
import android.provider.Settings
import androidx.annotation.NonNull
import androidx.core.content.pm.PackageInfoCompat
import com.google.gson.annotations.SerializedName
import io.aicactus.adsnetwork.internal.Exclude
import io.aicactus.adsnetwork.utils.SingletonHolder
import java.util.*
import kotlin.math.roundToInt

@SuppressLint("HardwareIds")
data class BatchContext(
    @NonNull @Exclude val context: Context,
) {

    @field:SerializedName("writeKey")
    var writeKey: String? = null

    @field:SerializedName("app")
    var app: App? = null

    @field:SerializedName("device")
    var device: Device? = null

    @field:SerializedName("os")
    var os: OS? = null

    @field:SerializedName("locale")
    var locale: String? = null

    @field:SerializedName("screen")
    var screen: Screen? = null

    @field:SerializedName("timezone")
    var timeZone: String? = null

    init {
        val packageInfo = context.packageManager.getPackageInfo(
            context.packageName,
            PackageManager.GET_META_DATA
        )

        val bundle = packageInfo.packageName
        val version = packageInfo.versionName
        val versionCode = PackageInfoCompat.getLongVersionCode(packageInfo)

        val applicationInfo = context.applicationInfo
        val name = context.packageManager.getApplicationLabel(applicationInfo).toString()

        app = App("$versionCode", name, bundle, version)

        val deviceId = Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID)
        device = Device(deviceId, Build.MANUFACTURER, Build.MODEL, Build.DEVICE, "Android")

        os = OS("Android", "${Build.VERSION.SDK_INT}")

        locale = Locale.getDefault().displayName

        val displayMetrics = context.resources.displayMetrics
        val widthPixels = displayMetrics.widthPixels
        val heightPixels = displayMetrics.heightPixels
        val density = displayMetrics.density

        val width = (widthPixels / density).roundToInt()
        val height = (heightPixels / density).roundToInt()
        screen = Screen("$width", "$height")

        timeZone = TimeZone.getDefault().id
    }

    companion object: SingletonHolder<BatchContext, Context>(::BatchContext)
}
