package io.aicactus.adsnetwork.internal

import android.content.Context
import android.content.pm.PackageInfo
import android.content.pm.PackageManager
import android.os.Build
import androidx.annotation.NonNull
import java.lang.RuntimeException
import java.util.*

class UserAgentGenerator(@NonNull private val context: Context) {
    private val packageInfo: PackageInfo?
        get() {
            try {
                return context.packageManager.getPackageInfo(context.packageName, PackageManager.GET_META_DATA)
            } catch (e: PackageManager.NameNotFoundException) {
                throw RuntimeException(e)
            }
        }

    val userAgent: String
        get() {
            val packageName = packageInfo?.packageName ?: DEFAULT_PACKAGE_NAME
            val versionName = packageInfo?.versionName ?: DEFAULT_VERSION_NAME
            val locale = Locale.getDefault()
            val sdkVersion = Aicactus.instances.version
            return "$packageName/$versionName AicactusAdsNetworkSDK/${sdkVersion} " +
                    "(Linux; U; Android ${Build.VERSION.RELEASE}; " +
                    "${locale.language}-${locale.country}; " +
                    "${Build.MODEL} Build/${Build.ID})"
        }

    companion object {
        private const val DEFAULT_PACKAGE_NAME = "UNKNOWN"
        private const val DEFAULT_VERSION_NAME = "UNKNOWN"
    }
}