package io.aicactus.adsnetwork.internal

import android.content.Context
import android.content.pm.PackageManager

private const val CONTAINER_ID = "io.aicactus.adsnetwork.CONTAINER_ID"

class SdkConfigurationParser {

    fun parse(context: Context): SdkConfiguration? {
        return runCatching {
            val metadata = context
                .packageManager
                .getApplicationInfo(context.packageName, PackageManager.GET_META_DATA)
                .metaData

            val containerId = metadata.getString(CONTAINER_ID)
            if (containerId != null) {
                return SdkConfiguration(containerId)
            }
            return null
        }.getOrNull()
    }
}