package io.aicactus.adsnetwork.internal

import androidx.annotation.NonNull
import androidx.annotation.Nullable
import java.lang.AssertionError

class AicactusApiResponse<T>(
    @NonNull val responseCode: AicactusApiResponseCode,
    @Nullable val responseData: T?,
    @NonNull val errorData: AicactusApiError,
) {

    val isSuccess: Boolean
        get() { return responseCode == AicactusApiResponseCode.SUCCESS }

    val isNetworkError: Boolean
        get() { return responseCode == AicactusApiResponseCode.NETWORK_ERROR }

    val isServerError: Boolean
        get() { return responseCode == AicactusApiResponseCode.SERVER_ERROR }

    companion object {

        private val EMPTY_RESULT_SUCCESS = AicactusApiResponse(
            AicactusApiResponseCode.SUCCESS,
            null,
            AicactusApiError.DEFAULT,
        )

        fun <T> createAsError(
            @NonNull responseCode: AicactusApiResponseCode,
            @NonNull errorData: AicactusApiError
        ): AicactusApiResponse<T> {
            if (responseCode == AicactusApiResponseCode.SUCCESS) {
                throw AssertionError()
            }
            return AicactusApiResponse(responseCode, null, errorData)
        }

        @Suppress("UNCHECKED_CAST")
        fun <T> createAsSuccess(@Nullable responseData: T?): AicactusApiResponse<T> {
            if (responseData == null) {
                return EMPTY_RESULT_SUCCESS as AicactusApiResponse<T>
            }
            return AicactusApiResponse(
                AicactusApiResponseCode.SUCCESS,
                responseData,
                AicactusApiError.DEFAULT
            )
        }
    }
}