package io.aicactus.adsnetwork.api

import android.content.Context
import androidx.annotation.NonNull
import io.aicactus.adsnetwork.internal.AicactusApiResponse
import io.aicactus.adsnetwork.internal.ServiceHttpClient
import io.aicactus.adsnetwork.models.container.Container
import io.aicactus.adsnetwork.utils.SingletonHolder
import io.aicactus.adsnetwork.utils.UriUtils

class CoreApiClient private constructor(@NonNull val context: Context) {
    @NonNull
    private val serviceHttpClient: ServiceHttpClient = ServiceHttpClient.getInstance(context)

    fun init(containerId: String): AicactusApiResponse<Container> {
        val uri = UriUtils.buildUri(
            ServiceHttpClient.CORE_API_SERVER_BASE_URI,
            BASE_PATH_CONTAINER_INIT,
            containerId,
        )
        return serviceHttpClient.get(uri, emptyMap(), emptyMap())
    }

    companion object: SingletonHolder<CoreApiClient, Context>(::CoreApiClient) {
        private const val BASE_PATH_CONTAINER_INIT = "container"
    }
}