package io.aicactus.adsnetwork.ads

import android.content.Context
import android.util.Log
import io.aicactus.adsnetwork.api.Result
import io.aicactus.adsnetwork.models.bid.Bid

class VideoAdLoader(
    context: Context,
    private val adUnitID: Int,
    private val adSize: AdSize,
) {

    private var adViewController = AdViewController.getInstance(context)

    var listener: VideoAdListener? = null

    fun loadAd(adRequest: AdRequest) {
        adViewController.request(adUnitID, adSize, AdType.VIDEO, adRequest) { response ->
            when (response) {
                is Result.Success<Bid> -> {
                    val bid = response.data
                    bid.adMarkup?.let { adMarkup ->
                        listener?.onVideoAdLoaded(adUnitID, bid, adMarkup)
                    } ?: run {
                        val message = "Load Ad failed: Cannot find Ad Markup"
                        Log.e("AdView", message)
                        listener?.onVideoAdFailedToLoad(adUnitID, message)
                    }
                }
                else -> {
                    val error = (response as Result.Error).error
                    val message = "Load Ad failed: ${error.getMessage()}"
                    Log.e("AdView", message)
                    listener?.onVideoAdFailedToLoad(adUnitID, message)
                }
            }
        }
    }

    companion object {
        inline fun build(context: Context, adUnitID: Int, adSize: AdSize, block: Builder.() -> Unit) =
            Builder(context, adUnitID, adSize).apply(block).build()
    }

    class Builder(
        private val context: Context,
        private val adUnitID: Int,
        private val adSize: AdSize,
    ) {
        fun build() = VideoAdLoader(context, adUnitID, adSize)
    }
}