package io.aicactus.adsnetwork.ads

import android.annotation.SuppressLint
import android.content.Context
import android.util.AttributeSet
import android.util.Log
import android.view.ViewGroup
import android.webkit.WebView
import android.webkit.WebViewClient
import io.aicactus.adsnetwork.api.Result
import io.aicactus.adsnetwork.models.bid.Bid

class AdView(context: Context, attributeSet: AttributeSet?) : BaseAdView(context, attributeSet) {

    constructor(context: Context): this(context, null)

    private var adViewController = AdViewController.getInstance(context)

    private val webView = WebView(context)

    var adListener: AdListener? = null

    override fun loadAd(adRequest: AdRequest) {
        if (unitId != null && size != null) {
            adViewController.request(unitId!!, size!!, type, adRequest) { response ->
                when(response) {
                    is Result.Success<Bid> -> {
                        val bid = response.data
                        bid.adMarkup?.let { adMarkup ->
                            attachView(adMarkup)
                            adListener?.onAdLoaded(unitId!!, bid)
                        } ?: run {
                            val message = "Load Ad failed: Cannot find Ad Markup"
                            Log.e("AdView", message)
                            adListener?.onAdFailedToLoad(unitId!!, message)
                        }
                    }
                    else -> {
                        val error = (response as Result.Error).error
                        val message = "Load Ad failed: ${error.getMessage()}"
                        Log.e("AdView", message)
                        adListener?.onAdFailedToLoad(unitId!!, message)
                    }
                }
            }
        } else {
            val message = "Load Ad failed: missing Ad unit ID or size"
            Log.e("AdView", message)
            unitId?.let { adListener?.onAdFailedToLoad(it,message) } ?: run {
                adListener?.onAdFailedToLoad(-1, message)
            }
        }
    }

    @SuppressLint("SetJavaScriptEnabled", "ClickableViewAccessibility")
    private fun attachView(adMarkup: String) {
        val html = createHTML(adMarkup)
        Log.e("AdView", "Load Ad: $html")
        webView.apply {
            webViewClient = WebViewClient()
            settings.apply {
                javaScriptEnabled = true
                mediaPlaybackRequiresUserGesture = false
            }
            isVerticalScrollBarEnabled = false
            isHorizontalScrollBarEnabled = false
        }
        webView.layoutParams = ViewGroup.LayoutParams(width, height)
        webView.loadDataWithBaseURL(null, html, "text/html", null, null)
        addView(webView)
    }

    private fun createHTML(adMarkup: String): String {
        return "<!DOCTYPE html>" +
                "<html>" +
                "<meta name=\"viewport\" content=\"width=$width, shrink-to-fit=YES\">" +
                "<body style=\"margin: 0; padding: 0\">$adMarkup</body>" +
                "</html>"
    }
}