package io.aicactus.adsnetwork.ads

import android.location.Location
import java.util.*

class AdRequest(val location: Location?) {

    val id: String = UUID.randomUUID().toString()

    private constructor(builder: Builder) : this(builder.location)

    companion object {
        inline fun build(block: Builder.() -> Unit) = Builder().apply(block).build()
    }

    class Builder {
        var location: Location? = null
        fun build() = AdRequest(this)
    }
}