/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.unit;

import io.agrest.ResourceEntity;
import io.agrest.RootResourceEntity;
import io.agrest.ToManyResourceEntity;
import io.agrest.ToOneResourceEntity;
import io.agrest.cayenne.compiler.CayenneAgEntityCompiler;
import io.agrest.cayenne.exp.CayenneExpParser;
import io.agrest.cayenne.exp.CayenneExpPostProcessor;
import io.agrest.cayenne.exp.ICayenneExpParser;
import io.agrest.cayenne.exp.ICayenneExpPostProcessor;
import io.agrest.cayenne.path.IPathResolver;
import io.agrest.cayenne.path.PathResolver;
import io.agrest.cayenne.persister.ICayennePersister;
import io.agrest.cayenne.processor.CayenneQueryAssembler;
import io.agrest.cayenne.processor.ICayenneQueryAssembler;
import io.agrest.compiler.AgEntityCompiler;
import io.agrest.compiler.AnnotationsAgEntityCompiler;
import io.agrest.meta.AgEntity;
import io.agrest.meta.AgSchema;
import io.agrest.meta.LazySchema;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.ObjEntity;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.Mockito;

public abstract class NoDbTest {
    protected ICayennePersister mockCayennePersister;
    protected IPathResolver pathDescriptorManager;
    protected AgSchema schema;
    protected CayenneQueryAssembler queryAssembler;

    protected static ServerRuntime createRuntime(String project) {
        Module module = binder -> {
            DataSourceFactory dsf = (DataSourceFactory)Mockito.mock(DataSourceFactory.class);
            binder.bind(DataSourceFactory.class).toInstance((Object)dsf);
        };
        return ServerRuntime.builder().addConfig(project).addModule(module).build();
    }

    protected abstract ServerRuntime getRuntime();

    @BeforeEach
    public void initAgSchema() {
        ObjectContext sharedContext = this.getRuntime().newContext();
        this.mockCayennePersister = (ICayennePersister)Mockito.mock(ICayennePersister.class);
        Mockito.when((Object)this.mockCayennePersister.entityResolver()).thenReturn((Object)this.getRuntime().getChannel().getEntityResolver());
        Mockito.when((Object)this.mockCayennePersister.sharedContext()).thenReturn((Object)sharedContext);
        Mockito.when((Object)this.mockCayennePersister.newContext()).thenReturn((Object)this.getRuntime().newContext());
        this.schema = new LazySchema(this.createEntityCompilers());
        this.pathDescriptorManager = new PathResolver(this.mockCayennePersister);
        this.queryAssembler = new CayenneQueryAssembler(this.mockCayennePersister, this.pathDescriptorManager, (ICayenneExpParser)new CayenneExpParser(), (ICayenneExpPostProcessor)new CayenneExpPostProcessor(this.pathDescriptorManager, this.mockCayennePersister));
    }

    protected List<AgEntityCompiler> createEntityCompilers() {
        CayenneAgEntityCompiler c1 = new CayenneAgEntityCompiler(this.mockCayennePersister, (ICayenneQueryAssembler)this.queryAssembler, Collections.emptyMap());
        AnnotationsAgEntityCompiler c2 = new AnnotationsAgEntityCompiler(Collections.emptyMap());
        return Arrays.asList(c1, c2);
    }

    protected <T> AgEntity<T> getAgEntity(Class<T> type) {
        return this.schema.getEntity(type);
    }

    protected ObjEntity getEntity(Class<?> type) {
        return this.getRuntime().getChannel().getEntityResolver().getObjEntity(type);
    }

    protected <T> RootResourceEntity<T> getResourceEntity(Class<T> type) {
        return new RootResourceEntity(this.getAgEntity(type));
    }

    protected <T> ToOneResourceEntity<T> getToOneChildEntity(Class<T> type, ResourceEntity<?> parent, String incoming) {
        return new ToOneResourceEntity(this.getAgEntity(type), parent, parent.getAgEntity().getRelationship(incoming));
    }

    protected <T> ToManyResourceEntity<T> getToManyChildEntity(Class<T> type, ResourceEntity<?> parent, String incoming) {
        return new ToManyResourceEntity(this.getAgEntity(type), parent, parent.getAgEntity().getRelationship(incoming));
    }
}

