/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.unit;

import io.agrest.cayenne.AgCayenneModule;
import io.agrest.cayenne.persister.CayennePersister;
import io.agrest.cayenne.persister.ICayennePersister;
import io.agrest.jaxrs3.junit.AgHttpTester;
import io.agrest.jaxrs3.junit.AgTestJaxrsFeature;
import io.agrest.runtime.AgRuntime;
import io.agrest.runtime.AgRuntimeBuilder;
import io.bootique.BQModule;
import io.bootique.BQRuntime;
import io.bootique.Bootique;
import io.bootique.cayenne.v42.CayenneModule;
import io.bootique.cayenne.v42.junit5.CayenneTester;
import io.bootique.command.CommandOutcome;
import io.bootique.di.Binder;
import io.bootique.di.Provides;
import io.bootique.jdbc.junit5.DbTester;
import io.bootique.jersey.JerseyModule;
import io.bootique.jersey.JerseyModuleExtender;
import io.bootique.jetty.junit5.JettyTester;
import io.bootique.junit5.BQTestScope;
import io.bootique.junit5.scope.BQAfterMethodCallback;
import io.bootique.junit5.scope.BQAfterScopeCallback;
import io.bootique.junit5.scope.BQBeforeMethodCallback;
import io.bootique.junit5.scope.BQBeforeScopeCallback;
import jakarta.ws.rs.client.WebTarget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import javax.inject.Singleton;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Module;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class AgCayenneTester
implements BQBeforeScopeCallback,
BQAfterScopeCallback,
BQBeforeMethodCallback,
BQAfterMethodCallback {
    protected DbTester<?> db;
    protected String cayenneProject;
    protected final List<Class<?>> resources = new ArrayList();
    protected Class<? extends Persistent>[] entities;
    protected Class<? extends Persistent>[] entitiesAndDependencies;
    protected BiFunction<AgRuntimeBuilder, ICayennePersister, AgRuntimeBuilder> agCustomizer = (b, p) -> b;
    protected boolean doNotCleanData = false;
    private JettyTester jettyInScope;
    private CayenneTester cayenneInScope;
    private BQRuntime appInScope;

    protected AgCayenneTester() {
        this.entities = new Class[0];
        this.entitiesAndDependencies = new Class[0];
    }

    public void assertQueryCount(int expected) {
        this.getCayenneInScope().assertQueryCount(expected);
    }

    public AgHttpTester target() {
        return AgHttpTester.request((WebTarget)this.internalTarget());
    }

    public AgHttpTester target(String path) {
        return this.target().path(path);
    }

    public WebTarget internalTarget() {
        return this.getJettyInScope().getTarget();
    }

    public AgRuntime runtime() {
        return (AgRuntime)this.getAppInScope().getInstance(AgRuntime.class);
    }

    protected CayenneTester getCayenneInScope() {
        return Objects.requireNonNull(this.cayenneInScope, "Not in test scope");
    }

    protected JettyTester getJettyInScope() {
        return Objects.requireNonNull(this.jettyInScope, "Not in test scope");
    }

    protected BQRuntime getAppInScope() {
        return Objects.requireNonNull(this.appInScope, "Not in test scope");
    }

    public void beforeScope(BQTestScope scope, ExtensionContext context) {
        this.jettyInScope = JettyTester.create();
        this.cayenneInScope = this.createCayenneInScope();
        this.appInScope = this.createAppInScope(this.jettyInScope, this.cayenneInScope);
        CommandOutcome result = this.appInScope.run();
        Assertions.assertTrue((boolean)result.isSuccess(), () -> result.getMessage());
        Assertions.assertTrue((boolean)result.forkedToBackground());
    }

    public void afterScope(BQTestScope scope, ExtensionContext context) {
        this.appInScope.shutdown();
        this.appInScope = null;
        this.jettyInScope = null;
        this.cayenneInScope = null;
    }

    public void beforeMethod(BQTestScope scope, ExtensionContext context) {
        this.getCayenneInScope().beforeMethod(scope, context);
    }

    public void afterMethod(BQTestScope scope, ExtensionContext context) {
        this.getCayenneInScope().afterMethod(scope, context);
    }

    protected CayenneTester createCayenneInScope() {
        CayenneTester tester = CayenneTester.create().skipSchemaCreation().entities((Class[])this.entities).entitiesAndDependencies((Class[])this.entitiesAndDependencies);
        if (!this.doNotCleanData) {
            tester.deleteBeforeEachTest();
        }
        return tester;
    }

    protected BQRuntime createAppInScope(JettyTester jetty, CayenneTester cayenne) {
        Bootique builder = Bootique.app((String[])new String[]{"-s"}).autoLoadModules().module(this.db.moduleWithTestDataSource("test")).module(jetty.moduleReplacingConnectors()).module(cayenne.moduleWithTestHooks()).module(b -> CayenneModule.extend((Binder)b).addProject(this.cayenneProject)).module((BQModule)new AgModule(this.agCustomizer, this.resources));
        return builder.createRuntime();
    }

    static class AgModule
    implements BQModule {
        private final BiFunction<AgRuntimeBuilder, ICayennePersister, AgRuntimeBuilder> customizer;
        private final List<Class<?>> resources;

        public AgModule(BiFunction<AgRuntimeBuilder, ICayennePersister, AgRuntimeBuilder> customizer, List<Class<?>> resources) {
            this.customizer = customizer;
            this.resources = resources;
        }

        public void configure(Binder binder) {
            this.configureJersey(JerseyModule.extend((Binder)binder));
        }

        private void configureJersey(JerseyModuleExtender extender) {
            extender.addFeature(AgTestJaxrsFeature.class);
            this.resources.forEach(arg_0 -> ((JerseyModuleExtender)extender).addResource(arg_0));
        }

        @Provides
        @Singleton
        AgRuntime provideAgRuntime(ServerRuntime runtime) {
            CayennePersister persister = new CayennePersister(runtime);
            AgRuntimeBuilder agBuilder = AgRuntime.builder().module((Module)AgCayenneModule.builder().persister((ICayennePersister)persister).build());
            return this.customizer.apply(agBuilder, (ICayennePersister)persister).build();
        }
    }

    public static abstract class Builder<T extends AgCayenneTester> {
        protected final T tester;

        protected Builder(T tester) {
            this.tester = tester;
        }

        public Builder<T> db(DbTester<?> db) {
            ((AgCayenneTester)this.tester).db = db;
            return this;
        }

        @SafeVarargs
        public final Builder<T> entities(Class<? extends Persistent> ... entities) {
            ((AgCayenneTester)this.tester).entities = Objects.requireNonNull(entities);
            return this;
        }

        @SafeVarargs
        public final Builder<T> entitiesAndDependencies(Class<? extends Persistent> ... entitiesWithDependencies) {
            ((AgCayenneTester)this.tester).entitiesAndDependencies = Objects.requireNonNull(entitiesWithDependencies);
            return this;
        }

        public Builder<T> resources(Class<?> ... resources) {
            ((AgCayenneTester)this.tester).resources.addAll(Arrays.asList(resources));
            return this;
        }

        public Builder<T> agCustomizer(UnaryOperator<AgRuntimeBuilder> agCustomizer) {
            return this.agCustomizer((AgRuntimeBuilder b, ICayennePersister p) -> (AgRuntimeBuilder)agCustomizer.apply((AgRuntimeBuilder)b));
        }

        public Builder<T> agCustomizer(BiFunction<AgRuntimeBuilder, ICayennePersister, AgRuntimeBuilder> agCustomizer) {
            ((AgCayenneTester)this.tester).agCustomizer = Objects.requireNonNull(agCustomizer);
            return this;
        }

        public Builder<T> cayenneProject(String cayenneProject) {
            ((AgCayenneTester)this.tester).cayenneProject = Objects.requireNonNull(cayenneProject);
            return this;
        }

        public T build() {
            Objects.requireNonNull(((AgCayenneTester)this.tester).db);
            Objects.requireNonNull(((AgCayenneTester)this.tester).cayenneProject);
            return this.tester;
        }
    }
}

