/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.spi;

import io.agrest.DataResponse;
import io.agrest.SelectStage;
import io.agrest.cayenne.cayenne.main.E2;
import io.agrest.cayenne.unit.main.MainDbTest;
import io.agrest.cayenne.unit.main.MainModelTester;
import io.agrest.jaxrs3.AgJaxrs;
import io.bootique.junit5.BQTestTool;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import org.apache.cayenne.validation.SimpleValidationFailure;
import org.apache.cayenne.validation.ValidationException;
import org.apache.cayenne.validation.ValidationFailure;
import org.apache.cayenne.validation.ValidationResult;
import org.junit.jupiter.api.Test;

public class ValidationExceptionMapperIT
extends MainDbTest {
    @BQTestTool
    static final MainModelTester tester = ValidationExceptionMapperIT.tester(Resource.class).build();

    @Test
    public void exception() {
        tester.target("/g1/1").get().wasBadRequest().bodyEquals("{\"message\":\"Object validation failed\"}");
        tester.target("/g1/2").get().wasBadRequest().bodyEquals("{\"message\":\"Object validation failed with 2 errors\"}");
    }

    @Path(value="")
    @Produces(value={"application/json"})
    public static class Resource {
        @Context
        private Configuration config;

        @GET
        @Path(value="g1/{failure_count}")
        public DataResponse<E2> getE2(@PathParam(value="failure_count") int failureCount, @Context UriInfo uriInfo) {
            return AgJaxrs.select(E2.class, (Configuration)this.config).stage(SelectStage.APPLY_SERVER_PARAMS, c -> {
                ValidationResult result = new ValidationResult();
                for (int i = 0; i < failureCount; ++i) {
                    result.addFailure((ValidationFailure)new SimpleValidationFailure(new Object(), (Object)"_error_"));
                }
                throw new ValidationException("_cayenne_validation_", result, new Object[0]);
            }).get();
        }
    }
}

