/*
 * Decompiled with CFR 0.152.
 */
package io.agrest.cayenne.processor;

import io.agrest.cayenne.processor.CayenneQueryAssembler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CayenneQueryAssembler_StaticsTest {
    @Test
    public void consumeRangeIterator_NoOffset_NoLimit_Negative() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeIterator(list.iterator(), (int)-1, (int)-1, consumed::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d"), consumed);
    }

    @Test
    public void consumeRangeIterator_NoOffset_NoLimit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeIterator(list.iterator(), (int)0, (int)0, consumed::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d"), consumed);
    }

    @Test
    public void consumeRangeIterator_Offset_Limit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeIterator(list.iterator(), (int)1, (int)2, consumed::add);
        Assertions.assertEquals(Arrays.asList("b", "c"), consumed);
    }

    @Test
    public void consumeRangeIterator_Offset_NoLimit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeIterator(list.iterator(), (int)1, (int)0, consumed::add);
        Assertions.assertEquals(Arrays.asList("b", "c", "d"), consumed);
    }

    @Test
    public void consumeRangeList_NoOffset_NoLimit_Negative() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeList(list, (int)-1, (int)-1, consumed::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d"), consumed);
    }

    @Test
    public void consumeRangeList_NoOffset_NoLimit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeList(list, (int)0, (int)0, consumed::add);
        Assertions.assertEquals(Arrays.asList("a", "b", "c", "d"), consumed);
    }

    @Test
    public void consumeRangeList_Offset_Limit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeList(list, (int)1, (int)2, consumed::add);
        Assertions.assertEquals(Arrays.asList("b", "c"), consumed);
    }

    @Test
    public void consumeRangeList_Offset_NoLimit() {
        List<String> list = Arrays.asList("a", "b", "c", "d");
        ArrayList consumed = new ArrayList();
        CayenneQueryAssembler.consumeRangeList(list, (int)1, (int)0, consumed::add);
        Assertions.assertEquals(Arrays.asList("b", "c", "d"), consumed);
    }
}

